<?php

/**
 * CustomerDataGridView
 *
 * @version    1.0
 * @package    samples
 * @subpackage tutor
 */
class CustomerDataGridView extends TPage
{
    public function __construct()
    {
        parent::__construct();
        
        // Painel de Documentação Necessária - Demolição
        $panel = new TPanelGroup('Documentação Necessária - Demolição');
        
        $content = "<div style='font-family: Arial, sans-serif; font-size: 14px; color: #333;'>
            <p>Para dar continuidade ao seu processo, tenha em mãos os seguintes documentos:</p>
            <ul style='list-style-type: disc; padding-left: 20px;'>
                <li><strong>RG/CPF</strong> do(s) proprietário(s) ou representante(s) legal(is). <span style='color: red;'>(Obrigatório)</span>
                    <ul style='list-style-type: circle; padding-left: 20px;'>
                        <li><strong>Empresas:</strong> apresentar <strong>CNPJ</strong> e <strong>Contrato Social</strong>. <span style='color: red;'>(Obrigatório)</span></li>
                    </ul>
                </li>
                <li><strong>Certidão de inteiro teor</strong> atualizada. <span style='color: red;'>(Obrigatório)</span></li>
                <li><strong>Escritura pública</strong> registrada em cartório. <span style='color: red;'>(Obrigatório)</span></li>
                <li><strong>Ficha de conformidade</strong> do IPTU. <span style='color: red;'>(Obrigatório)</span></li>
                <li><strong>Plantas</strong> de localização e situação. <span style='color: red;'>(Obrigatório)</span></li>
                <li><strong>ART</strong> assinada pelo engenheiro e proprietário. <span style='color: red;'>(Obrigatório)</span></li>
            </ul>
            <p style='margin-top: 10px;'><em>Por favor, Certifique-se de que todos os documentos estejam atualizados e legíveis para evitar qualquer atraso no andamento.</em></p>
        </div>";
        
        $html = new TTextDisplay($content, 'black', '14px', 'b');
        
        $panel->add($html);
        
        // Adicionando o botão de download
        $button = new TElement('a');
        $button->href = 'index.php?class=WindowPDFView';
        $button->class = 'btn btn-info';
        $button->generator = 'adianti';
        $button->add('<i class="fa fa-download" aria-hidden="true"></i> <b>&nbsp;Download</b> - Checklist');
        
        $panel->add($button);
        
        // Painel de Iniciar Processo
        $processPanel = new TPanelGroup('Processo');
        
        // Criando o botão grande e verde
        $startButton = new TElement('a');
        $startButton->href = 'index.php?class=SidePageView'; // Defina a URL do link para iniciar o processo
        $startButton->class = 'btn btn-success '; // Estilo de botão grande e verde
        $startButton->generator = 'adianti';
        $startButton->add('<i class="fa fa-newspaper" aria-hidden="true"></i> <b>&nbsp;Iniciar o Processo</b>');
       
        $processPanel->add($startButton);
        
        // Criando o container principal
        $container = new TVBox;
        $container->style = 'width: 100%; max-width: 100%; margin: auto; padding: 20px;';
        $container->add($panel);
        $container->add($processPanel); // Adicionando o painel do processo
        
        parent::add($container);
    }
}

