<?php

class TaskService extends AdiantiRecordService
{
    const DATABASE      = 'external_pgsql';
    const ACTIVE_RECORD = 'Task';
    const ATTRIBUTES    = [
        'id',
        'title',
        'status',
        'assigned_to',
        'created_at',
        'updated_at',
        'project',
        'description',
        'start_date',
        'due_date'
    ];

    /**
     * Retorna todas as tarefas
     */
    public static function getTasks($param = null)
    {
        try {
            TTransaction::open(self::DATABASE);

            $criteria = new TCriteria(); // Você pode aplicar filtros com base em $param aqui se quiser
            $repo = new TRepository(self::ACTIVE_RECORD);
            $tasks = $repo->load($criteria);

            $result = [];

            if ($tasks) {
                foreach ($tasks as $task) {
                    $result[] = $task->toArray();
                }
            }

            TTransaction::close();
            return $result;
        } catch (Exception $e) {
            TTransaction::rollback();
            return ['error' => $e->getMessage()];
        }
    }

    /**
     * Atualiza o status da tarefa
     */
    public static function updateTaskStatus($param)
    {
        try {
            TTransaction::open(self::DATABASE);

            $task = new Task($param['id']);
            $task->status = $param['status'];
            $task->store();

            TTransaction::close();
            return $task->toArray();
        } catch (Exception $e) {
            TTransaction::rollback();
            return ['error' => $e->getMessage()];
        }
    }
}
