<?php
use Adianti\Control\TPage;
use Adianti\Control\TAction;
use Adianti\Wrapper\BootstrapFormBuilder;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Form\TCombo;
use Adianti\Widget\Wrapper\TDBCombo;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Container\TPanelGroup;

class LogradouroForm extends TPage
{
    private $form;

    public function __construct()
    {
        parent::__construct();

        $this->form = new BootstrapFormBuilder('form_Logradouro');
        $this->form->setFormTitle('Logradouro');
        $this->form->setFieldSizes('100%');

        $id=new TEntry('id');$id->setEditable(FALSE);$id_tipo_logradouro=new TDBCombo('id_tipo_logradouro','comum','TipoLogradouro','id','nome');$id_bairro_inicial=new TDBCombo('id_bairro_inicial','comum','Bairro','id','nome');$id_bairro_fim=new TDBCombo('id_bairro_fim','comum','Bairro','id','nome');$nome=new TEntry('nome');$cep=new TEntry('cep_logradouro');$complemento=new TEntry('complemento');$this->form->addFields([new TLabel('ID'),$id],[new TLabel('Tipo'),$id_tipo_logradouro]);$this->form->addFields([new TLabel('Nome'),$nome],[new TLabel('CEP'),$cep],[new TLabel('Compl.'),$complemento]);$this->form->addFields([new TLabel('Bairro Inicial'),$id_bairro_inicial],[new TLabel('Bairro Final'),$id_bairro_fim]);

        $this->form->addAction('Salvar', new TAction([$this, 'onSave']), 'fa:save');
        $this->form->addAction('Voltar', new TAction(['LogradouroList', 'onReload']), 'fa:arrow-left');

        $panel = new TPanelGroup('Logradouro');
        $panel->add($this->form);
        parent::add($panel);
    }

    public function onSave($param)
    {
        try {
            TTransaction::open('comum');

            $object = new Logradouro;
            $data = $this->form->getData();

            $object->fromArray((array) $data);
            $object->store();

            TTransaction::close();
            new TMessage('info', 'Registro salvo com sucesso');
            TApplication::gotoPage('LogradouroList');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onEdit($param)
    {
        try {
            TTransaction::open('comum');
            if (isset($param['id'])) {
                $object = new Logradouro($param['id']);
                $this->form->setData($object->toArray());
            } else {
                $this->form->clear();
            }
            TTransaction::close();
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onClear($param = null)
    {
        $this->form->clear(TRUE);
    }
}
