<?php
use Adianti\Control\TPage;
use Adianti\Control\TAction;
use Adianti\Wrapper\BootstrapFormBuilder;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Form\TCombo;
use Adianti\Widget\Wrapper\TDBCombo;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Container\TPanelGroup;

class PaisForm extends TPage
{
    private $form;

    public function __construct()
    {
        parent::__construct();

        $this->form = new BootstrapFormBuilder('form_Pais');
        $this->form->setFormTitle('Pais');
        $this->form->setFieldSizes('100%');

        $id=new TEntry('id');$id->setEditable(FALSE);$nome=new TEntry('nome');$nacionalidade=new TEntry('nacionalidade');$sigla2=new TEntry('sigla_com2');$sigla3=new TEntry('sigla_com3');$numero=new TEntry('numero');$this->form->addFields([new TLabel('ID'),$id],[new TLabel('Nome'),$nome]);$this->form->addFields([new TLabel('Nacionalidade'),$nacionalidade],[new TLabel('Sigla 2'),$sigla2],[new TLabel('Sigla 3'),$sigla3]);$this->form->addFields([new TLabel('Número'),$numero]);

        $this->form->addAction('Salvar', new TAction([$this, 'onSave']), 'fa:save');
        $this->form->addAction('Voltar', new TAction(['PaisList', 'onReload']), 'fa:arrow-left');

        $panel = new TPanelGroup('Pais');
        $panel->add($this->form);
        parent::add($panel);
    }

    public function onSave($param)
    {
        try {
            TTransaction::open('comum');

            $object = new Pais;
            $data = $this->form->getData();

            $object->fromArray((array) $data);
            $object->store();

            TTransaction::close();
            new TMessage('info', 'Registro salvo com sucesso');
            TApplication::gotoPage('PaisList');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onEdit($param)
    {
        try {
            TTransaction::open('comum');
            if (isset($param['id'])) {
                $object = new Pais($param['id']);
                $this->form->setData($object->toArray());
            } else {
                $this->form->clear();
            }
            TTransaction::close();
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onClear($param = null)
    {
        $this->form->clear(TRUE);
    }
}
