<?php
use Adianti\Control\TAction;
use Adianti\Control\TPage;
use Adianti\Widget\Container\TPanelGroup;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Form\TEntry;
use Adianti\Database\TRepository;
use Adianti\Database\TCriteria;
use Adianti\Database\TFilter;
use Adianti\Widget\Wrapper\TQuickForm;
use Adianti\Widget\Datagrid\TDataGridColumn;
use Adianti\Widget\Datagrid\TDataGridAction;
use Adianti\Widget\Datagrid\TDataGrid;
use Adianti\Widget\Dialog\TQuestion;

use Adianti\Database\TTransaction;

// Compat: alias para TSession em diferentes versões
if (!class_exists('TSession')) {
    if (class_exists('\Adianti\Core\TSession')) {
        class_alias('\Adianti\Core\TSession', 'TSession');
    } elseif (class_exists('\Adianti\Registry\TSession')) {
        class_alias('\Adianti\Registry\TSession', 'TSession');
    }
}

class PaisList extends TPage
{
    private $form;
    private $datagrid;
    private $loaded;

    public function __construct()
    {
        parent::__construct();

        // Formulário de busca
        $this->form = new TQuickForm('form_search_Pais');
        $this->form->setFormTitle('País - Busca');

        $id   = new TEntry('id');
        $nome = new TEntry('nome');

        $this->form->addQuickField('ID',   $id,   100);
        $this->form->addQuickField('Nome', $nome, 300);

        $this->form->setData( TSession::getValue('search_Pais') );

        $this->form->addQuickAction('Buscar', new TAction([$this, 'onSearch']), 'fa:search');
        $this->form->addQuickAction('Novo',   new TAction(['PaisForm', 'onClear']), 'fa:plus green');

        // Grid
        $this->datagrid = new TDataGrid;
        $this->datagrid->style     = 'width: 100%';
        $this->datagrid->datatable = 'true';

        $col_id            = new TDataGridColumn('id', 'ID', 'center', '8%');
        $col_nome          = new TDataGridColumn('nome', 'Nome', 'left', '36%');
        $col_nacionalidade = new TDataGridColumn('nacionalidade', 'Nacionalidade', 'left', '24%');
        $col_sigla2        = new TDataGridColumn('sigla_com2', 'Sigla (2)', 'center', '12%');
        $col_sigla3        = new TDataGridColumn('sigla_com3', 'Sigla (3)', 'center', '12%');
        $col_numero        = new TDataGridColumn('numero', 'Número', 'center', '8%');

        $this->datagrid->addColumn($col_id);
        $this->datagrid->addColumn($col_nome);
        $this->datagrid->addColumn($col_nacionalidade);
        $this->datagrid->addColumn($col_sigla2);
        $this->datagrid->addColumn($col_sigla3);
        $this->datagrid->addColumn($col_numero);

        // Ações
        $action_edit = new TDataGridAction(['PaisForm', 'onEdit']);
        $action_edit->setLabel('Editar');
        $action_edit->setImage('fa:edit blue');
        $action_edit->setField('id');

        $action_del  = new TDataGridAction([$this, 'onDelete']);
        $action_del->setLabel('Excluir');
        $action_del->setImage('fa:trash red');
        $action_del->setField('id');

        $this->datagrid->addAction($action_edit);
        $this->datagrid->addAction($action_del);

        $this->datagrid->createModel();

        // Painel
        $panel = new TPanelGroup('País - Lista');
        $panel->add($this->form);
        $panel->add($this->datagrid);

        parent::add($panel);
    }

    public function onSearch($param)
    {
        $data = $this->form->getData();
        TSession::setValue('search_Pais', $data);
        $this->onReload($param);
    }

    public function onReload($param = null)
    {
        try {
            TTransaction::open('comum');

            $repository = new TRepository('Pais');
            $criteria   = new TCriteria;

            $data = TSession::getValue('search_Pais');

            if ($data) {
                if (!empty($data->id)) {
                    $criteria->add(new TFilter('id', '=', $data->id));
                }
                if (!empty($data->nome)) {
                    $criteria->add(new TFilter('nome', 'ilike', "%{$data->nome}%"));
                }
            }

            $objects = $repository->load($criteria);

            $this->datagrid->clear();
            if ($objects) {
                foreach ($objects as $object) {
                    $this->datagrid->addItem($object);
                }
            }

            TTransaction::close();
            $this->loaded = true;
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onDelete($param)
    {
        $action = new TAction([$this, 'Delete']);
        $action->setParameters($param);
        new TQuestion('Confirma excluir?', $action);
    }

    public function Delete($param)
    {
        try {
            TTransaction::open('comum');
            $object = new Pais($param['id']);
            $object->delete();
            TTransaction::close();
            $this->onReload();
            new TMessage('info', 'Registro excluído');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function show()
    {
        if (!$this->loaded) {
            $this->onReload(func_get_arg(0));
        }
        parent::show();
    }
}
