<?php
use Adianti\Control\TPage;
use Adianti\Control\TAction;
use Adianti\Wrapper\BootstrapFormBuilder;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Form\TCombo;
use Adianti\Widget\Wrapper\TDBCombo;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Widget\Container\TPanelGroup;

class TipoLogradouroForm extends TPage
{
    private $form;

    public function __construct()
    {
        parent::__construct();

        $this->form = new BootstrapFormBuilder('form_TipoLogradouro');
        $this->form->setFormTitle('TipoLogradouro');
        $this->form->setFieldSizes('100%');

        $id=new TEntry('id');$id->setEditable(FALSE);$nome=new TEntry('nome');$sigla=new TEntry('sigla');$this->form->addFields([new TLabel('ID'),$id],[new TLabel('Nome'),$nome],[new TLabel('Sigla'),$sigla]);

        $this->form->addAction('Salvar', new TAction([$this, 'onSave']), 'fa:save');
        $this->form->addAction('Voltar', new TAction(['TipoLogradouroList', 'onReload']), 'fa:arrow-left');

        $panel = new TPanelGroup('TipoLogradouro');
        $panel->add($this->form);
        parent::add($panel);
    }

    public function onSave($param)
    {
        try {
            TTransaction::open('comum');

            $object = new TipoLogradouro;
            $data = $this->form->getData();

            $object->fromArray((array) $data);
            $object->store();

            TTransaction::close();
            new TMessage('info', 'Registro salvo com sucesso');
            TApplication::gotoPage('TipoLogradouroList');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onEdit($param)
    {
        try {
            TTransaction::open('comum');
            if (isset($param['id'])) {
                $object = new TipoLogradouro($param['id']);
                $this->form->setData($object->toArray());
            } else {
                $this->form->clear();
            }
            TTransaction::close();
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }

    public function onClear($param = null)
    {
        $this->form->clear(TRUE);
    }
}
