<?php
/**
 * AlvaraView
 *
 * Página central com layout moderno.
 *
 * @version    8.0
 * @package    control
 */
class AlvaraView extends TPage
{
    /**
     * Constructor method
     */
    public function __construct()
    {
        parent::__construct();

        $this->form = new BootstrapFormBuilder('form_side_page');
        $this->form->setFormTitle('CADASTRO');
        $this->form->generateAria();

        parent::setTargetContainer('adianti_right_panel');

        // Campos básicos
        $tipoAlvara = new TCombo('tipo_alvara');
        $tipoAlvara->addItems([ 'demolicao' => 'Alvará de Demolição', 'construcao' => 'Alvará de Construção > 200m²']);
        $tipoAlvara->setChangeAction(new TAction([$this, 'onTipoChange']));

        $solicitacaoalvara = new TEntry('solicitacao_alvara');
        $cadastroImobiliario = new TEntry('cadastro_imobiliario');
        $cpfCnpj = new TEntry('cpf_cnpj');
        $rgOrgao = new TEntry('rg_orgao');
        $nome = new TEntry('nome');
        $logradouro = new TEntry('logradouro');
        $complemento = new TEntry('complemento');
        $numero = new TEntry('numero');
        $bairro = new TEntry('bairro');
        $telefone = new TEntry('telefone');
        $quadra = new TEntry('quadra');
        $lote = new TEntry('lote');

        $escritura = new TFile('escritura');
        $certidao = new TFile('certidao');
        $fichaIptu = new TFile('ficha_iptu');
        $plantas = new TFile('plantas');
        $art = new TFile('art');

        $projetoArq = new TFile('proj_arquitetonico');
        $projetoEletrico = new TFile('proj_eletrico');
        $projetoHidraulico = new TFile('proj_hidraulico');
        $projetoEstrutural = new TFile('proj_estrutural');
        $memorial = new TFile('memorial');

        // Validações
        $cadastroImobiliario->addValidation('Cadastro Imobiliário', new TRequiredValidator);
        $cpfCnpj->addValidation('CPF/CNPJ', new TRequiredValidator);
        $rgOrgao->addValidation('RG/Órgão', new TRequiredValidator);
        $nome->addValidation('Nome', new TRequiredValidator);
        $logradouro->addValidation('Logradouro', new TRequiredValidator);
        $complemento->addValidation('Complemento', new TRequiredValidator);
        $bairro->addValidation('Bairro', new TRequiredValidator);
        $telefone->addValidation('Telefone', new TRequiredValidator);
        $numero->addValidation('Número', new TRequiredValidator);
        $quadra->addValidation('Quadra', new TRequiredValidator);
        $lote->addValidation('Lote', new TRequiredValidator);

        // Campos iniciais
        $this->form->addFields([new TLabel('Tipo de Alvará *')], [$tipoAlvara]);
        $this->form->addFields([new TLabel('Solicitação')], [$solicitacaoalvara]);
        $this->form->addFields([new TLabel('Cadastro Imobiliário *')], [$cadastroImobiliario]);
        $this->form->addFields([new TLabel('CPF/CNPJ *')], [$cpfCnpj]);
        $this->form->addFields([new TLabel('RG/Órgão *')], [$rgOrgao]);

        $this->form->addContent([new TFormSeparator('IDENTIFICAÇÃO')]);
        $this->form->addFields([new TLabel('Nome *')], [$nome]);

        $this->form->addContent([new TFormSeparator('LOCALIZAÇÃO DO IMÓVEL')]);
        $this->form->addFields([new TLabel('Logradouro *')], [$logradouro]);
        $this->form->addFields([new TLabel('Complemento *')], [$complemento]);
        $this->form->addFields([new TLabel('Bairro *')], [$bairro]);
        $this->form->addFields([new TLabel('Telefone *')], [$telefone]);
        $this->form->addFields([new TLabel('Número *')], [$numero], [new TLabel('Quadra *')], [$quadra], [new TLabel('Lote *')], [$lote]);

        $this->form->addContent([new TFormSeparator('DOCUMENTAÇÃO NECESSÁRIA')]);

        // Agrupamento dos campos por tipo de alvará
        $frameDemolicao = new TElement('div');
        $frameDemolicao->id = 'frame_demolicao';
        $frameDemolicao->style = 'display:none';
        $frameDemolicao->add(new TLabel('Certidão de inteiro teor atualizada *'));
        $frameDemolicao->add($certidao);
        $frameDemolicao->add(new TLabel('Escritura pública registrada em cartório *'));
        $frameDemolicao->add($escritura);
        $frameDemolicao->add(new TLabel('Ficha de conformidade do IPTU *'));
        $frameDemolicao->add($fichaIptu);
        $frameDemolicao->add(new TLabel('Plantas de localização e situação *'));
        $frameDemolicao->add($plantas);
        $frameDemolicao->add(new TLabel('ART assinada pelo engenheiro e proprietário *'));
        $frameDemolicao->add($art);

        $frameConstrucao = new TElement('div');
        $frameConstrucao->id = 'frame_construcao';
        $frameConstrucao->style = 'display:none';
        $frameConstrucao->add(new TLabel('Certidão de inteiro teor atualizada *'));
        $frameConstrucao->add($certidao);
        $frameConstrucao->add(new TLabel('Escritura pública registrada em cartório *'));
        $frameConstrucao->add($escritura);
        $frameConstrucao->add(new TLabel('Ficha de conformidade do IPTU *'));
        $frameConstrucao->add($fichaIptu);
        $frameConstrucao->add(new TLabel('Projeto arquitetônico assinado *'));
        $frameConstrucao->add($projetoArq);
        $frameConstrucao->add(new TLabel('Projeto elétrico assinado *'));
        $frameConstrucao->add($projetoEletrico);
        $frameConstrucao->add(new TLabel('Projeto hidrossanitário assinado *'));
        $frameConstrucao->add($projetoHidraulico);
        $frameConstrucao->add(new TLabel('Projeto estrutural assinado *'));
        $frameConstrucao->add($projetoEstrutural);
        $frameConstrucao->add(new TLabel('Memorial descritivo *'));
        $frameConstrucao->add($memorial);
        $frameConstrucao->add(new TLabel('ART assinada pelo engenheiro e proprietário *'));
        $frameConstrucao->add($art);

        $this->form->addContent([$frameDemolicao]);
        $this->form->addContent([$frameConstrucao]);

        $this->form->addAction('Enviar', new TAction([$this, 'onSave']), 'far:check-circle green');
        $this->form->addAction('Fechar', new TAction([$this, 'onClose']), 'fa:times red');

        $container = new TVBox;
        $container->style = 'width: 100%';
        $container->add($this->form);

        parent::add($container);
    }

    public static function onTipoChange($param)
{
    $tipo = $param['tipo_alvara'] ?? '';
    $show_demolicao = ($tipo === 'demolicao');
    $show_construcao = ($tipo === 'construcao');

    TScript::create("
        document.getElementById('frame_demolicao').style.display = '" . ($show_demolicao ? 'block' : 'none') . "';
        document.getElementById('frame_construcao').style.display = '" . ($show_construcao ? 'block' : 'none') . "';
    ");   
}

    public function onSave($param)
    {
        try {
            $data = (object) $param;
            $this->form->validate();
            new TMessage('info', 'Dados salvos com sucesso!');
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
        }
    }

    public function onClose($param)
    {
        TScript::create("Template.closeRightPanel()");
    }
    
}


