<?php
/**
 * MapaUsoSoloView
 *
 * @version    8.0
 * @package    control
 * @author     Pablo Dall'Oglio
 * @copyright  Copyright (c) 2006 Adianti Solutions Ltd. (http://www.adianti.com.br)
 * @license    https://adiantiframework.com.br/license-template
 */
class MapaUsoSoloView extends TPage
{
    function __construct()
    {
        parent::__construct();
        
        // Obtém o grupo do usuário e o nome do usuário da sessão
        $userGroupId = TSession::getValue('usergroupids') ?? '0';
        $username = TSession::getValue('username') ?? 'Desconhecido'; // Defina um valor padrão caso o nome de usuário não esteja disponível

        // Se for array, converte para string
        $userGroupIdString = is_array($userGroupId) ? implode(',', $userGroupId) : $userGroupId;

        // Debug no log do PHP
        error_log('usergroupids: ' . $userGroupIdString);
        error_log('username: ' . $username);

        // Cria o HTML Renderer
        $this->html = new THtmlRenderer('vendor/geojequie/MapaUsoSolo/mapa_uso_solo.php');
        
        $ini = AdiantiApplicationConfig::get();
        
        $replaces = [
            'title'       => _t('Uso e Ocupação do solo'),
            'content'     => $ini['general']['Uso e Ocupação do solo'] ?? '',
            'usergroupid' => $userGroupIdString, // Adiciona o grupo do usuário
            'username'    => $username,          // Adiciona o nome do usuário
            'script'      => "<script>
                                sessionStorage.setItem('usergroupids', '{$userGroupIdString}'); 
                                console.log('Grupo do usuário:', '{$userGroupIdString}');
                              </script>"
        ];
        
        // Substitui as variáveis na seção principal
        $this->html->enableSection('main', $replaces);
        
        parent::add($this->html);
    }
}




