<?php

use Adianti\Base\TStandardForm;
use Adianti\Control\TPage;
use Adianti\Widget\Form\TEntry;
use Adianti\Widget\Form\TFile;
use Adianti\Widget\Form\TButton;
use Adianti\Wrapper\BootstrapFormBuilder;
use Adianti\Widget\Container\TVBox;
use Adianti\Database\TTransaction;
use Adianti\Widget\Dialog\TMessage;
use Adianti\Validator\TRequiredValidator;
use Adianti\Widget\Wrapper\TDBCombo;

class SolicitacaoAlvaraForm extends TPage // Alterado de TStandardForm para TPage
{
    protected $form;

    public function __construct()
    {
        parent::__construct();
        
        $this->form = new BootstrapFormBuilder('form_solicitacao_alvara');
        $this->form->setFormTitle('Cadastro de Solicitação de Alvará');

        $id = new TEntry('id');
        $id->setEditable(false);
        
        $nome = new TEntry('nome');
        $endereco = new TEntry('endereco');
        $responsavel = new TEntry('responsavel');
        $documento = new TFile('documento');

        $nome->addValidation('Nome', new TRequiredValidator());
        $endereco->addValidation('Endereço', new TRequiredValidator());

        $this->form->addFields([new TLabel('ID')], [$id]);
        $this->form->addFields([new TLabel('Nome')], [$nome]);
        $this->form->addFields([new TLabel('Endereço')], [$endereco]);
        $this->form->addFields([new TLabel('Responsável Técnico')], [$responsavel]);
        $this->form->addFields([new TLabel('Documento')], [$documento]);

        $this->form->addAction('Salvar', new TAction([$this, 'onSave']), 'fa:save green');
        $this->form->addActionLink('Voltar', new TAction(['SolicitaçãoAlvaraList', 'onReload']), 'fa:arrow-left');

        $vbox = new TVBox();
        $vbox->style = 'width: 100%';
        $vbox->add($this->form);
        parent::add($vbox);
    }

    public function onSave($param) // Assinatura agora é compatível
    {
        try {
            TTransaction::open('database');
            $this->form->validate();
            
            $data = $this->form->getData();
            $solicitacao = new SolicitaçãoAlvara();
            $solicitacao->fromArray((array) $data);

            if (!empty($data->documento)) {
                $sourcePath = $data->documento;
                $destPath = 'files/' . basename($sourcePath);
                move_uploaded_file($sourcePath, $destPath);
                $solicitacao->documento = $destPath;
            }

            $solicitacao->store();
            TTransaction::close();

            new TMessage('info', 'Solicitação salva com sucesso!');
            $this->form->setData($solicitacao);
        } catch (Exception $e) {
            new TMessage('error', $e->getMessage());
            TTransaction::rollback();
        }
    }
}