<?php

header('Content-Type: application/json; charset=UTF-8');

class ApiModel extends Model {

    private static function autenticar() {
        $url = 'https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/auth';
        $data = [
            'usuario' => 'PM_BA_JEQUIE',
            'senha' => '8e39d3b8-500a'
        ];

        $jsonData = json_encode($data);
        
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $jsonData,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
            CURLOPT_TIMEOUT => 10,
        ]);

        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            self::logMessage('Erro ao obter token: ' . $error);
            return false;
        }

        $responseData = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE || !isset($responseData['token'])) {
            self::logMessage('Erro ao decodificar resposta do token: ' . json_last_error_msg());
            return false;
        }

        return $responseData['token'];
    }

    private static function apiRequest($url, $data) {
        $token = self::autenticar();
        if (!$token) return false;

        $jsonData = json_encode($data);

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $jsonData,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                "Authorization: Bearer $token"
            ],
            CURLOPT_TIMEOUT => 10,
        ]);

        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if ($error) {
            self::logMessage('Erro na requisição: ' . $error);
            return false;
        }

        return json_decode($response, true);
    }

    public static function consultarInscricao($inscricao) {
        return self::apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/inscricao', ['inscricao_municipal' => $inscricao]);
    }

    public static function consultarPessoa($documento) {
        return self::apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/pessoa', ['documento' => $documento]);
    }

    public static function consultarLogradouro($logra) {
        return self::apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/logradouro', ['nome' => $logra]);
    }

    public static function consultarBairro($bairro) {
        return self::apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/bairro', ['nome' => $bairro]);
    }

    public static function consultarCidade($cidade) {
        return self::apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/consulta/cidade', ['nome' => $cidade]);
    }

    public static function cadastrarInscricao($dados) {
        return self::apiRequest('https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/cadastro', $dados);
    }

    private static function logMessage($message) {
        error_log($message, 3, __DIR__ . '/error_log.txt');
    }
}
