(function () {


  // 🔧 Variáveis principais
  var drawMeasure = null;
  var currentDrawType = null;
  var tipPoint;
  var activeMeasurement = null;

  // ✅ HTML que aparece no painel lateral
  var measurementPanelHTML = `
  <section class="measurement-tools">
    <div class="measurement-tools__buttons tool-group">
      <button type="button" onclick="btnMedirDistancia()" title="Medir distância" class="btn-icon" aria-label="Medir distância">
        <i class="fas fa-ruler"></i>
      </button>
      <button type="button" onclick="btnMedirArea()" title="Medir área" class="btn-icon" aria-label="Medir área">
        <i class="fas fa-draw-polygon"></i>
      </button>
      <button type="button" onclick="clearMeasurements()" title="Limpar medidas" class="btn-icon btn-icon--danger" aria-label="Limpar medidas">
        <i class="fas fa-trash-alt"></i>
      </button>      
    </div>    
  </section>
`;

  // 🎨 Estilos das geometrias
  var style = new ol.style.Style({
    fill: new ol.style.Fill({ color: 'rgba(255,255,255,0.2)' }),
    stroke: new ol.style.Stroke({ color: 'rgba(0,0,0,0.5)', lineDash: [10, 10], width: 2 }),
    image: new ol.style.Circle({
      radius: 5,
      stroke: new ol.style.Stroke({ color: 'rgba(0,0,0,0.7)' }),
      fill: new ol.style.Fill({ color: 'rgba(255,255,255,0.2)' })
    })
  });

  var labelStyle = new ol.style.Style({
    text: new ol.style.Text({
      font: '14px Calibri,sans-serif',
      fill: new ol.style.Fill({ color: 'white' }),
      backgroundFill: new ol.style.Fill({ color: 'rgba(0,0,0,0.7)' }),
      padding: [3, 3, 3, 3],
      textBaseline: 'bottom',
      offsetY: -15
    })
  });

  var tipStyle = new ol.style.Style({
    text: new ol.style.Text({
      font: '12px Calibri,sans-serif',
      fill: new ol.style.Fill({ color: 'white' }),
      backgroundFill: new ol.style.Fill({ color: 'rgba(0,0,0,0.4)' }),
      padding: [2, 2, 2, 2],
      textAlign: 'left',
      offsetX: 15
    })
  });

  var segmentStyle = new ol.style.Style({
    text: new ol.style.Text({
      font: '12px Calibri,sans-serif',
      fill: new ol.style.Fill({ color: 'white' }),
      backgroundFill: new ol.style.Fill({ color: 'rgba(0,0,0,0.4)' }),
      padding: [2, 2, 2, 2],
      textBaseline: 'bottom',
      offsetY: -12
    })
  });

  var segmentStyles = [];

  var modifyStyle = new ol.style.Style({
    image: new ol.style.Circle({
      radius: 5,
      stroke: new ol.style.Stroke({ color: 'rgba(0, 0, 0, 0.7)' }),
      fill: new ol.style.Fill({ color: 'rgba(0, 0, 0, 0.4)' })
    }),
    text: new ol.style.Text({
      text: 'Arraste para modificar',
      font: '12px Calibri,sans-serif',
      fill: new ol.style.Fill({ color: 'white' }),
      backgroundFill: new ol.style.Fill({ color: 'rgba(0, 0, 0, 0.7)' }),
      padding: [2, 2, 2, 2],
      offsetX: 15
    })
  });

  // 📏 Cálculo
  var getLength = ol.sphere.getLength;
  var getArea = ol.sphere.getArea;

  // 🗺️ Fonte e camada
  var measureSource = new ol.source.Vector();
  var measureLayer = new ol.layer.Vector({
    source: measureSource,
    style: function (feature) {
      return styleFunction(feature, true);
    }
  });
  measureLayer.setZIndex(40);

  function formatLength(line) {
    var length = getLength(line);
    return length > 100 ? (length / 1000).toFixed(2) + ' km' : length.toFixed(2) + ' m';
  }

  function formatArea(polygon) {
    var area = getArea(polygon);
    return area > 10000 ? (area / 1000000).toFixed(2) + ' km²' : area.toFixed(2) + ' m²';
  }

  function openMeasurementPanel() {
    if (window.userGroupId !== 1) {
      alert("Você não tem permissão para usar a ferramenta de medição.");
      return;
    }

    // Usa a função utilitária para abrir/fechar e destacar
    if (!setActiveTool('#btn-medicao', "Medição")) return;

    document.getElementById("slide-title").textContent = "Medição";
    document.getElementById("slide-content").innerHTML = measurementPanelHTML;
  }

  function closeSlidePanel() {
    document.getElementById("slide-panel").style.display = "none";
    document.querySelectorAll('#tools-panel button.active').forEach(btn => btn.classList.remove('active'));
  }

  function btnMedirDistancia() {
    if (window.userGroupId !== 1) return;
    if (activeMeasurement === "distance") {
      deactivateButtons();
      stopMeasuring();
      activeMeasurement = null;
    } else {
      activateButton('distance');
      stopMeasuring();
      startMeasuringDistance();
      activeMeasurement = "distance";
    }
  }

  function btnMedirArea() {
    if (window.userGroupId !== 1) return;
    if (activeMeasurement === "area") {
      deactivateButtons();
      stopMeasuring();
      activeMeasurement = null;
    } else {
      activateButton('area');
      stopMeasuring();
      startMeasuringArea();
      activeMeasurement = "area";
    }
  }

  function startMeasuringDistance() {
    startDrawMeasure('LineString');
  }

  function startMeasuringArea() {
    startDrawMeasure('Polygon');
  }

  function startDrawMeasure(type) {
    if (window.userGroupId !== 1) return;
    if (drawMeasure) map.removeInteraction(drawMeasure);

    var idvarip = 'Clique para iniciar a medição';
    var activeTip = type === 'Polygon' ? 'Clique para continuar o polígono' : 'Clique para continuar a linha';
    var tip = idvarip;

    drawMeasure = new ol.interaction.Draw({
      source: measureSource,
      type: type,
      style: function (feature) {
        return styleFunction(feature, true, type, tip);
      }
    });

    drawMeasure.on('drawstart', function () {
      tip = activeTip;
      tipPoint = null;
    });

    drawMeasure.on('drawend', function () {
      modifyStyle.setGeometry(tipPoint);
      map.once('pointermove', () => modifyStyle.setGeometry(null));
      tip = idvarip;
    });

    map.addInteraction(drawMeasure);
  }

  function stopMeasuring() {
    if (window.userGroupId !== 1) return;
    if (drawMeasure) {
      map.removeInteraction(drawMeasure);
      drawMeasure = null;
    }
  }

  function clearMeasurements() {
    if (window.userGroupId !== 1) return;
    measureSource.clear();
    if (drawMeasure) {
      map.removeInteraction(drawMeasure);
      drawMeasure = null;
    }
    deactivateButtons();
    activeMeasurement = null;
  }

  function activateButton(type) {
    var btnDist = document.querySelector('button[onclick="btnMedirDistancia()"]');
    var btnArea = document.querySelector('button[onclick="btnMedirArea()"]');
    if (type === 'distance') {
      btnDist?.classList.add('active');
      btnArea?.classList.remove('active');
    } else {
      btnArea?.classList.add('active');
      btnDist?.classList.remove('active');
    }
  }

  function deactivateButtons() {
    document.querySelectorAll('.btn-icon.active').forEach(btn => btn.classList.remove('active'));
  }

  function styleFunction(feature, segments, drawType, tip) {
    var styles = [];
    var geometry = feature.getGeometry();
    var type = geometry.getType();
    var point, label, line;

    if (!drawType || drawType === type || type === 'Point') {
      styles.push(style);
      if (type === 'Polygon') {
        point = geometry.getInteriorPoint();
        label = formatArea(geometry);
        line = new ol.geom.LineString(geometry.getCoordinates()[0]);
      } else if (type === 'LineString') {
        point = new ol.geom.Point(geometry.getLastCoordinate());
        label = formatLength(geometry);
        line = geometry;
      }
    }

    if (segments && line) {
      var count = 0;
      line.forEachSegment((a, b) => {
        var segment = new ol.geom.LineString([a, b]);
        var labelText = formatLength(segment);
        if (!segmentStyles[count]) {
          segmentStyles.push(segmentStyle.clone());
        }
        var segmentPoint = new ol.geom.Point(segment.getCoordinateAt(0.5));
        segmentStyles[count].setGeometry(segmentPoint);
        segmentStyles[count].getText().setText(labelText);
        styles.push(segmentStyles[count]);
        count++;
      });
    }

    if (label) {
      labelStyle.setGeometry(point);
      labelStyle.getText().setText(label);
      styles.push(labelStyle);
    }

    if (tip && type === 'Point') {
      tipPoint = geometry;
      tipStyle.getText().setText(tip);
      tipStyle.setGeometry(tipPoint);
      styles.push(tipStyle);
    }

    return styles;
  }

  // 🧩 Inicializa a camada de medição só para grupo 1
  if (window.userGroupId === 1) {
    map.addLayer(measureLayer);
    map.addInteraction(new ol.interaction.Modify({
      source: measureSource,
      style: modifyStyle
    }));
  }

  // Expondo funções globalmente
  window.openMeasurementPanel = openMeasurementPanel;
  window.btnMedirDistancia = btnMedirDistancia;
  window.btnMedirArea = btnMedirArea;
  window.clearMeasurements = clearMeasurements;
  window.closeSlidePanel = closeSlidePanel;
})();
