<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Defina o tipo de resposta para JSON
header('Content-Type: application/json');

// Configuração do banco de dados
$host = "162.240.148.136";
$port = "5432";
$dbname = "wwsisp_postgres";
$user = "postgres";
$password = "R312@dm1nj3q";

// Conectar ao banco de dados
$pdo = new PDO("pgsql:host=$host;port=$port;dbname=$dbname", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Obter o corpo da requisição
$data = json_decode(file_get_contents('php://input'), true);

// Verificar se os dados necessários foram enviados
if (isset($data['id']) && isset($data['status_solicitacao']) && isset($data['userGroupId'])) {
    $id = $data['id'];
    $status_solicitacao = $data['status_solicitacao'];
    $userGroupId = $data['userGroupId'];

    // Permitir atualização de status_solicitacao apenas para usuários do grupo 1
    if ($userGroupId != "1") {
        echo json_encode(['status' => 'erro', 'mensagem' => 'Você não tem permissão para atualizar o status_solicitacao.']);
        exit;
    }

    // Prevenir injeção SQL usando prepared statements
    $sql = "UPDATE solicitacoes SET status_solicitacao = :status_solicitacao WHERE id = :id";
    $stmt = $pdo->prepare($sql); // Corrigido de $conn para $pdo

    // Vincular os parâmetros
    $stmt->bindParam(':status_solicitacao', $status_solicitacao, PDO::PARAM_STR);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Tentar executar a consulta
    try {
        if ($stmt->execute()) {
            echo json_encode(['status' => 'sucesso', 'mensagem' => 'Status atualizado com sucesso.']);
        } else {
            echo json_encode(['status' => 'erro', 'mensagem' => 'Erro ao atualizar o status_solicitacao.']);
        }
    } catch (PDOException $e) {
        echo json_encode(['status' => 'erro', 'mensagem' => 'Erro de banco de dados: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Dados incompletos.']);
}
?>
