<?php

header('Content-Type: application/json; charset=UTF-8');

var_dump($_POST);


// Função para obter o token
function getToken() {
    $url = 'https://gpi02.cloud.el.com.br/ServerExec/tributario/tributarioclient/auth';
    $data = [
        'usuario' => 'PM_BA_JEQUIE',
        'senha' => '8e39d3b8-500a'
    ];

    $jsonData = json_encode($data);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);  // Timeout de 10 segundos

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        logMessage('Erro ao obter token: ' . curl_error($ch));
        curl_close($ch);
        return false;
    }

    curl_close($ch);

    $responseData = json_decode($response, true);

    if (json_last_error() !== JSON_ERROR_NONE || !isset($responseData['token'])) {
        logMessage('Erro ao decodificar resposta do token: ' . json_last_error_msg());
        return false;
    }

    return $responseData['token'];
}

// Obter o token
$token = getToken();
if (!$token) {
    http_response_code(500);
    echo json_encode(['error' => 'Falha ao obter token de autenticação']);
    exit();
}

// Realizar a consulta com o token obtido
$url = 'https://gpi20.cloud.el.com.br/ServerExec/tributario/tributarioclient/bci/ac/cadastro';
$data = [
    'codigo' => $codigo
];

// Log dos dados enviados
logMessage("Dados enviados para a API: " . json_encode($data, JSON_UNESCAPED_UNICODE));

// Validar os dados antes de enviar
if (empty($data['codigo'])) {
    http_response_code(400);
    echo json_encode(['error' => 'codigo está vazio ou nulo']);
    exit();
}

$jsonData = json_encode($data, JSON_UNESCAPED_UNICODE);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Bearer ' . $token,
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);  // Timeout de 10 segundos

$response = curl_exec($ch);

$info = curl_getinfo($ch);
$httpCode = $info['http_code'];
$totalTime = $info['total_time'];

if (curl_errno($ch)) {
    $errorMessage = curl_error($ch);
    logMessage("Erro na requisição: $errorMessage");
    echo json_encode(['error' => 'Erro na requisição: ' . $errorMessage]);
    curl_close($ch);
    exit();
}

curl_close($ch);

// Log da resposta bruta para análise
logMessage("Resposta da API: $response");
logMessage("HTTP Code: $httpCode");
logMessage("Tempo total: $totalTime");

// Capturar e registrar a resposta da API, mesmo se houver erro HTTP
if ($httpCode !== 200) {
    logMessage("Erro HTTP na resposta: $httpCode");
    echo json_encode(['error' => "Erro HTTP na resposta: $httpCode", 'response' => $response]);
    exit();
}

// Forçar a codificação para UTF-8 se a detecção falhar
$encoding = mb_detect_encoding($response, mb_detect_order(), true);
if ($encoding === false) {
    logMessage("Não foi possível detectar a codificação, forçando UTF-8");
    $response = utf8_encode($response);
} elseif ($encoding !== 'UTF-8') {
    $response = mb_convert_encoding($response, 'UTF-8', $encoding);
}

logMessage("Resposta convertida: $response");

// Verificar se a resposta é válida JSON
if (!isJson($response)) {
    logMessage("Resposta não é um JSON válido");
    echo json_encode(['error' => 'Resposta não é um JSON válido', 'response' => $response]);
    exit();
}

$responseData = json_decode($response, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    logMessage("Erro ao decodificar JSON: " . json_last_error_msg());
    echo json_encode(['error' => 'Erro ao decodificar JSON: ' . json_last_error_msg()]);
    exit();
}

logMessage("JSON decodificado: " . print_r($responseData, true));

echo json_encode($responseData, JSON_UNESCAPED_UNICODE);

function logMessage($message) {
    file_put_contents('error_log.txt', date('Y-m-d H:i:s') . " - $message\n", FILE_APPEND);
}

function isJson($string) {
    json_decode($string);
    return json_last_error() === JSON_ERROR_NONE;
}
?>
