<?php
require 'vendor/autoload.php';
use Dompdf\Dompdf;

$dompdf = new Dompdf();
$dompdf->loadHtml('<h1>Olá, Dompdf!</h1><p>Teste com PHP 8.0.</p>');
$dompdf->setPaper('A4', 'portrait');


try {
    $dompdf->render();
    file_put_contents('./geojequie/teste_pdf.pdf', $dompdf->output());
    echo json_encode(["status" => "success", "message" => "PDF gerado com sucesso"]);
} catch (Exception $e) {
    error_log("Erro ao gerar PDF: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Erro na geração do PDF"]);
}

?>
