<?php
$searchType = isset($_POST['searchType']) ? $_POST['searchType'] : '';
$query = isset($_POST['query']) ? $_POST['query'] : '';
$operator = isset($_POST['operator']) ? $_POST['operator'] : ''; // Recebe o operador

if ($searchType && $query) {
    // Definindo a consulta conforme o tipo de pesquisa
    switch ($searchType) {
        case 'nome':
            $column = 'name';
            break;
        case 'cpf':
            $column = 'numero_doc';
            break;
        case 'inscricao':
            $column = 'inscricao';
            break;
        case 'quadra':
            $column = 'quadra';
            break;
        case 'lote':
            $column = 'lote';
            break;
        case 'setor':
            $column = 'setor';
            break;                 
        default:
            $column = 'name';
            break;
    }

    // Montando a cláusula WHERE com base no operador selecionado
    switch ($operator) {
        case 'contains':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column ILIKE :query
                        ORDER BY bairro";
            break;
        case 'notContains':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column NOT ILIKE :query
                        ORDER BY bairro";
            break;
            case 'startsWith':
                // Quando "Começa com", usamos ILIKE e adicionamos o wildcard '%' no final
                $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                            longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                            FROM cadastro_2025_postgis 
                            WHERE $column ILIKE :query || '%'
                            ORDER BY bairro";
                break;
        case 'endsWith':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column ILIKE '%' || :query
                        ORDER BY bairro";
            break;
        case 'equals':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column = :query
                        ORDER BY bairro";
            break;
        case 'notEqual':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column != :query
                        ORDER BY bairro";
            break;
        case 'lessThan':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column < :query
                        ORDER BY bairro";
            break;
        case 'greaterThan':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column > :query
                        ORDER BY bairro";
            break;
        case 'lessThanOrEqual':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column <= :query
                        ORDER BY bairro";
            break;
        case 'greaterThanOrEqual':
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column >= :query
                        ORDER BY bairro";
            break;
        case 'between':
            // Para o operador 'between', espera-se que a consulta seja algo como "10e20"
            $range = explode('e', $query); 
            if (count($range) == 2) {
                $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                            longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                            FROM cadastro_2025_postgis 
                            WHERE $column BETWEEN :min AND :max
                            ORDER BY bairro";
                // Bind para o intervalo
                $stmt->bindValue(':min', $range[0], PDO::PARAM_STR);
                $stmt->bindValue(':max', $range[1], PDO::PARAM_STR);
            }
            break;
        default:
            $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                        longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                        FROM cadastro_2025_postgis 
                        WHERE $column ILIKE :query
                        ORDER BY bairro";
            break;
    }
} else {
    // Consulta padrão caso não haja tipo de pesquisa ou termo de pesquisa
    $strQry = "SELECT id, inscricao, name, numero_doc, bairro, logradouro, quadra, lote, numero_lot, unidade, utilizacao, area_terre, area_unida,
                longitude, latitude, situacao, zoneamento, inscricao_uni, setor, ST_AsGeoJSON(geom, 15) as geom 
                FROM cadastro_2025_postgis 
                ORDER BY bairro";
}

// Conexão com o banco de dados
$db = new PDO('pgsql:host=162.240.148.136;port=5432;dbname=wwsisp_postgres;', 'postgres', 'R312@dm1nj3q');

// Preparando a consulta
$stmt = $db->prepare($strQry);
if ($searchType && $query && $operator != 'between') {
    $stmt->bindValue(':query', '%' . $query . '%', PDO::PARAM_STR);
}

// Executando a consulta
$stmt->execute();

// Recuperando os dados
$features = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $feature = ['type' => 'Feature'];
    $feature['geometry'] = json_decode($row['geom']);
    unset($row['geom']);
    $feature['properties'] = $row;
    array_push($features, $feature);
    $feature['properties']['longitude'] = $row['longitude'];
    $feature['properties']['latitude'] = $row['latitude'];
}

$featureCollection = ['type' => 'FeatureCollection', 'features' => $features];

// Retornando os dados como JSON
echo json_encode($featureCollection);
?>
