// Exemplo de como manipular a exibição com JavaScript
document.addEventListener('DOMContentLoaded', function () {
    var userGroupId = 1;

    // Controla a exibição de ações baseadas no grupo do usuário
    if (userGroupId === 1) {
        document.getElementById('admin-actions').style.display = 'block';
    } else if (userGroupId === 2) {
        document.getElementById('client-actions').style.display = 'block';
    }

    // Função para verificar se o usuário está logado
    function isLoggedIn() {
        return sessionStorage.setItem("userLoggedIn", "true"); 
    }
});

// ===== Camadas Base =====
var googleHybrid = L.tileLayer('https://mt1.google.com/vt/lyrs=s&x={x}&y={y}&z={z}', { maxZoom: 22 });
var wmsJequieLayer = createWMSLayer('sisprom:jequie_full_gsd06cm_2025_total');

// ===== Camadas WMS =====
var wmsQuadraLayer = createWMSLayer('sisprom:QUADRA_PINDORAMA');
var wmsRuasLayer = createWMSLayer('sisprom:ruas_jequie_2023_wgs84');
var wmsRotuloLoteLayer = createWMSLayer('sisprom:CADASTRO_GERAL_2025_ROTULO');
var wmsCorredoresdeUsoDiversificadoILayer = createWMSLayer('sisprom:Corredores_de_Uso_Diversificado_I');
var wmsCorredoresdeUsoDiversificadoIILayer = createWMSLayer('sisprom:Corredores_de_Uso_Diversificado_II');
var wmsCampusUniversitarioLayer = createWMSLayer('sisprom:Campus_Universitário');
var wmsCentroHistoricoLayer = createWMSLayer('sisprom:Centro_Histórico');
var wmsCentroInstitucionalMunicipalLayer = createWMSLayer('sisprom:Centro_Institucional_Municipal');
var wmsCentroTradicionalMunicipalLayer = createWMSLayer('sisprom:Centro_Tradicional_Municipal');
var wmsDistritoIndustrialILayer = createWMSLayer('sisprom:Distrito_Industrial_I');
var wmsDistritoIndustrialIILayer = createWMSLayer('sisprom:Distrito_Industrial_II');
var wmsParquedaCidadeLayer = createWMSLayer('sisprom:Parque_da_Cidade');
var wmsZR1Layer = createWMSLayer('sisprom:ZR-1');
var wmsZR2Layer = createWMSLayer('sisprom:ZR-2');
var wmsZR3Layer = createWMSLayer('sisprom:ZR-3');
var wmsZR4Layer = createWMSLayer('sisprom:ZR-4');
var wmsZR5Layer = createWMSLayer('sisprom:ZR-5');

// Terceira camada WMS para o logradouro de Jequié
var wmsImoveisLayer = L.tileLayer.wms("https://sisprom-br.com.br:8443/geoserver/sisprom/wms", {
    layers: 'sisprom:imoveis_jequie',
    format: 'image/png',
    transparent: true,
    version: '1.1.0',
    srs: 'EPSG:32724',
    minZoom: 10,
    maxZoom: 22
});
// Função para criar camadas de pavimentos dinamicamente com filtros
function criarCamadapavimentos(pavimentos) {
    return L.tileLayer.wms("https://sisprom-br.com.br:8443/geoserver/sisprom/wms", {
        layers: 'sisprom:imoveis_jequie',
        format: 'image/png',
        transparent: true,
        version: '1.1.0',
        cql_filter: `pavimentos='${pavimentos}'`, // Filtro CQL para pavimentos
        srs: 'EPSG:32724',
        minZoom: 10,
        maxZoom: 22
    });
}
// Criar camadas para cada pavimentos
var pavimentosP0 = criarCamadapavimentos('P-0');
var pavimentosP1 = criarCamadapavimentos('P-1');
var pavimentosP2 = criarCamadapavimentos('P-2');
var pavimentosP3 = criarCamadapavimentos('P-3');

// ===== Inicializa o Mapa =====
var map = L.map("map", {
    center: [-13.8607, -40.0786],
    zoom: 14,
    minZoom: 10,
    maxZoom: 22,
    zoomControl: false,
    editable: true,
    layers: [googleHybrid]
});

// ===== Adiciona controle de zoom =====
var zoom_bar = new L.Control.ZoomBar({ position: 'topleft' }).addTo(map);

// ===== Adiciona controle de scale =====
L.control.scale().addTo(map);
map.on('mousemove', updateCoordinates);

// ===== Estilos =====
var defaultWFSStyle = { color: '#0000FF', weight: 1, opacity: 0.5, fillOpacity: 0.05 };

// ===== Camadas WFS =====
var wfsLayer = L.geoJSON(null, { onEachFeature: onEachWFSFeature, style: defaultWFSStyle });

loadWFS();

// ===== Controle de Camadas =====
var groupedOverlays = {
    "MAPA BASE": {
        "Mapa Base": wfsLayer
    },
    "IMÓVEIS": {
                "Todos os Imóveis": wmsImoveisLayer,
                "pavimentos P-0": pavimentosP0,
                "pavimentos P-1": pavimentosP1,
                "pavimentos P-2": pavimentosP2,
                "pavimentos P-3": pavimentosP3
            },
    "OUTRAS CAMADAS": {
        "Ruas/Avenidas": wmsRuasLayer,
        "Lotes": wmsRotuloLoteLayer,
        "Quadras": wmsQuadraLayer
    },
    "Plano Diretor Municipal": {
        "Corredores de Uso Diversificado I": wmsCorredoresdeUsoDiversificadoILayer,
        "Corredores de Uso Diversificado II": wmsCorredoresdeUsoDiversificadoIILayer,
        "Campus Universitário": wmsCampusUniversitarioLayer,
        "Centro Histórico": wmsCentroHistoricoLayer,
        "Centro Institucional Municipal": wmsCentroInstitucionalMunicipalLayer,
        "Centro Tradicional Municipal": wmsCentroTradicionalMunicipalLayer,
        "Distrito Industrial I": wmsDistritoIndustrialILayer,
        "Distrito Industrial II": wmsDistritoIndustrialIILayer,
        "Parque da Cidade": wmsParquedaCidadeLayer,
        "ZR - 01": wmsZR1Layer,
        "ZR - 02": wmsZR2Layer,
        "ZR - 03": wmsZR3Layer,
        "ZR - 04": wmsZR4Layer,
        "ZR - 05": wmsZR5Layer
    }
};

var controlLayers = L.control.groupedLayers(
    { "Google Hybrid": googleHybrid, "Ortophoto Jan2024": wmsJequieLayer },
    groupedOverlays,
    { collapsed: window.innerWidth < 768 }
).addTo(map);

map.addLayer(wfsLayer);
map.addLayer(wmsRuasLayer);
map.addLayer(wmsRotuloLoteLayer);

// ===== Funções Auxiliares =====
function createWMSLayer(layerName) {
    return L.tileLayer.wms("https://sisprom-br.com.br:8443/geoserver/sisprom/wms", {
        layers: layerName,
        format: 'image/png',
        transparent: true,
        version: '1.1.0',
        srs: 'EPSG:32724',
        minZoom: 10,
        maxZoom: 22
    });
}

function updateCoordinates(e) {
    document.getElementById('map_coords').innerHTML = `
            <strong>Lat:</strong> ${e.latlng.lat.toFixed(4)}
            <strong>Long:</strong> ${e.latlng.lng.toFixed(4)}
            <strong>Zoom:</strong> ${map.getZoom()}`;
}

// ===== wfsLayer =====
// Aguarde o carregamento completo do WFS antes de processar a inscrição
function loadWFS() {
    fetch('https://sisprom-br.com.br:8443/geoserver/sisprom/wfs?service=WFS&version=2.0.0&request=GetFeature&typeNames=sisprom:Jequie_2025_postgis&outputFormat=application/json&srsName=EPSG:4326')
        .then(response => response.json())
        .then(data => {
            wfsLayer.addData(data);
            console.log("Dados WFS carregados.");
            // Após carregar, tente localizar a inscrição, se houver
            if (inscricao) {
                setTimeout(() => highlightInscricao(inscricao), 500);
            }
        })
        .catch(error => console.error('Erro ao carregar WFS:', error));
}

function onEachWFSFeature(feature, layer) {
    layer.bindPopup(` 
            <div style="font-family: Arial, sans-serif; width: 190px; padding: 10px; border-radius: 8px; background: #fff; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                <h4 style="margin: 0 0 6px; font-size: 16px; color: #2c3e50; text-align: center;">Informações do Lote</h4>
                <hr style="margin: 6px 0 10px; border: none; height: 1px; background: #ccc;">
                <table style="width: 100%; font-size: 13px; line-height: 1.3;">
                    <tr><td><strong>Inscrição:</strong></td><td style="text-align: right;">${feature.properties.inscricao}</td></tr>
                    <tr><td><strong>Lote:</strong></td><td style="text-align: right;">${feature.properties.lote}</td></tr>
                    <tr><td><strong>Quadra:</strong></td><td style="text-align: right;">${feature.properties.quadra}</td></tr>
                    <tr><td><strong>Latitude:</strong></td><td style="text-align: right;">${feature.properties.latitude.toFixed(5)}</td></tr>
                    <tr><td><strong>Longitude:</strong></td><td style="text-align: right;">${feature.properties.longitude.toFixed(5)}</td></tr>
                </table>
                <div style="display: flex; justify-content: space-between; gap: 8px; margin-top: 10px;">
                    <a class="btn btn-info" generator="adianti" 
                        href="index.php?class=Consulta_ElFormView&inscricao=${feature.properties.inscricao}&modo=consulta" 
                        style="flex: 1; display: flex; align-items: center; justify-content: center; gap: 4px; background: #2980b9; color: white; padding: 6px 8px; border-radius: 4px; text-decoration: none; font-size: 13px; font-weight: 500;">
                        <i class="fas fa-building"></i> Consultar
                    </a>
                    
                </div>            
            </div>
        `);

    drawnItems.addLayer(layer);
    layer.on('click', (e) => highlightFeature(layer, e.latlng));
}

// ===== Destaque de Polígono =====
var highlightedLayer = null;
function highlightFeature(layer, latlng) {
    if (highlightedLayer) wfsLayer.resetStyle(highlightedLayer);
    layer.setStyle({ color: '#FF0000', weight: 3, opacity: 0.7, fillOpacity: 0.1 });
    highlightedLayer = layer;
    map.setView(latlng, 19);
}

// ===== Obtém a inscrição =====
// Função para obter parâmetros da URL
function getQueryParam(param) {
    let urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(param);
}
// Aguarde até que o GeoJSON seja completamente carregado
function highlightInscricao(inscricao) {
    let found = false;

    wfsLayer.eachLayer(layer => {
        if (layer.feature && layer.feature.properties.inscricao === inscricao) {
            let bounds = layer.getBounds(); // Obtém os limites do polígono

            if (bounds.isValid()) { // Verifica se os limites são válidos
                found = true;
                let center = bounds.getCenter(); // Obtém o centro do polígono

                map.setView(center, 19); // Define o zoom fixo para 19

                layer.setStyle({
                    fillColor: 'yellow',
                    color: 'red',
                    weight: 3,
                    fillOpacity: 0.7
                });
                // Simula um clique no polígono para abrir as informações
                layer.fire('click');
            } else {
                console.warn("Os limites do polígono são inválidos para a inscrição:", inscricao);
            }
        }
    });

    if (!found) {
        console.warn("Inscrição não encontrada no WFS:", inscricao);
    }
}

// Obtém a inscrição da URL e aguarda o carregamento
var inscricao = getQueryParam("inscricao");

// ===== Medição de Área e Comprimento =====
var isMeasuring = false;
var measureControl = new L.Control.Measure({
    position: "topleft",
    primaryLengthUnit: "meters",
    secondaryLengthUnit: "kilometers",
    primaryAreaUnit: "sqmeters",
    secondaryAreaUnit: "hectares"
});

document.getElementById("MeasureArea").addEventListener("click", function (e) {
    e.preventDefault();
    isMeasuring = !isMeasuring;
    isMeasuring ? map.addControl(measureControl) : map.removeControl(measureControl);
    this.classList.toggle("selected");
});

// ===== Minha Localização =====
(function () {
    let userLocationMarker = null;
    document.getElementById('widgetUserLocation').addEventListener('click', function () {
        toggleUserLocation();
        this.classList.toggle('selected');
    });
    function toggleUserLocation() {
        if (userLocationMarker) {
            map.removeLayer(userLocationMarker);
            userLocationMarker = null;
        } else {
            navigator.geolocation.getCurrentPosition(
                function (position) {
                    const userLatLng = L.latLng(position.coords.latitude, position.coords.longitude);
                    userLocationMarker = L.marker(userLatLng).addTo(map).bindPopup("Você está aqui!").openPopup();
                    map.setView(userLatLng, 15);
                },
                function (error) {
                    alert("Não foi possível acessar sua localização: " + error.message);
                }
            );
        }
    }
})();

// ===== Pesquisar Inscrição e Nome =====
var searchControl = new L.Control.Search({
    layer: wfsLayer,
    zoom: 20,
    collapsed: false, // Mantém visível
    position: 'topleft',
    initial: false,
    hideMarkerOnCollapse: true,
    propertyName: 'inscricao',
    filterData: customPropertySearch,
    moveToLocation: (latlng, title, map) => map.setView(latlng, 20)
}).addTo(map);

// Função para filtrar busca por Inscrição e Nome
function customPropertySearch(text) {
    var filteredData = {};
    var normalizedText = text.trim().toLowerCase();
    wfsLayer.eachLayer(layer => {
        var props = layer.feature.properties;
        var inscricao = props.inscricao?.toString().toLowerCase() || '';
        var name = props.name?.toString().toLowerCase() || '';
        if (inscricao.includes(normalizedText) || name.includes(normalizedText)) {
            filteredData[props.inscricao || props.name] = layer;
        }
    });
    return filteredData;
}

// Mover os campos de busca para a barra superior
document.getElementById('search-control-container').appendChild(document.querySelector('.leaflet-control-search')); // Move a busca por inscrição e nome

// Impedir que o Enter faça o mapa descer
document.querySelectorAll('.leaflet-control input').forEach(input => {
    input.addEventListener('keydown', function (e) {
        if (e.key === 'Enter') {
            e.preventDefault(); // Bloqueia o Enter
        }
    });
});

// ===== Pesquisar Endereço ===== 
var osmGeocoder = new L.Control.Geocoder({
    collapsed: false,
    position: 'topright',
    text: 'Search',
    title: 'Testing',
}).addTo(map);

// Mover o geocoder para a barra superior
var geocoderEl = document.querySelector('.leaflet-control-geocoder');
var searchContainer = document.getElementById('search-control-container-geocoder');
if (geocoderEl && searchContainer) {
    searchContainer.appendChild(geocoderEl);
}
// ===== Desenhar Polígono =====
var styleEditor;
var styleEditorActive = false; // Controle do estado do StyleEditor
// Evento para ativar/desativar o StyleEditor
document.getElementById('widgetStyleEditor').addEventListener('click', function () {
    var button = this; // Referência ao botão
    if (styleEditorActive) {
        // Remove o StyleEditor do mapa
        if (styleEditor) {
            map.removeControl(styleEditor);
            styleEditor = null; // Redefine a variável
        }
        styleEditorActive = false;
        button.src = "voo360/assets/icons3d/palette.svg"; // Ícone para indicar desativado
        button.classList.remove('selected'); // Remove o contorno
    } else {
        // Adiciona o StyleEditor ao mapa
        styleEditor = L.control.styleEditor({
            position: 'topleft',
        }).addTo(map);
        styleEditorActive = true;
        button.src = "voo360/assets/icons3d/palette.svg"; // Ícone para indicar ativado
        button.classList.add('selected'); // Adiciona o contorno
    }
});
// Variável para rastrear o estado da medição
var isMeasuring = false;
// Adiciona o featureGroup para armazenar os polígonos desenhados e marcadores
var drawnItems = new L.FeatureGroup();
map.addLayer(drawnItems);
// Inicializa o controle de desenho, mas sem adicionar ao mapa ainda
var drawControl = new L.Control.Draw({
    draw: {
        polygon: {
            shapeOptions: {
                stroke: true,
                color: 'black',       // Cor da linha do polígono
                fillColor: 'yellow',  // Cor de preenchimento do polígono
                weight: 2             // Largura da borda
            },
            showArea: true  // Mostrar área automaticamente
        },
        polyline: true,
        rectangle: false,
        circle: false,
        marker: true,
        circlemarker: false
    },
    edit: {
        featureGroup: drawnItems,  // Permite editar os polígonos desenhados e marcadores
        remove: true  // Permite deletar os objetos
    }
});
// Função para alternar a ferramenta de medição ao clicar no ícone
document.getElementById('widgetMeasureArea').addEventListener('click', function (e) {
    e.preventDefault();

    if (isMeasuring) {
        // Desativa o modo de desenho ao remover o controle de medição
        map.removeControl(drawControl);
        isMeasuring = false;
        document.getElementById("widgetMeasureArea").src = "voo360/assets/icons3d/pen.png";
        // Remove a classe .selected do ícone
        document.getElementById("widgetMeasureArea").classList.remove("selected");
    } else {
        // Ativa o modo de desenho ao adicionar o controle de medição
        map.addControl(drawControl);
        isMeasuring = true;
        document.getElementById("widgetMeasureArea").src = "voo360/assets/icons3d/pen.png";
        // Adiciona a classe .selected ao ícone
        document.getElementById("widgetMeasureArea").classList.add("selected");
    }
});
// Captura o evento de criação de um polígono ou marcador e adiciona-o ao mapa
map.on('draw:created', function (e) {
    var type = e.layerType,
        layer = e.layer;
    // Adiciona o objeto desenhado (polígono ou marcador) ao featureGroup
    drawnItems.addLayer(layer);
    // Exibe um log no console para ajudar no desenvolvimento
    if (type === 'marker') {
        console.log('Marcador adicionado: ', layer.getLatLng());
    } else if (type === 'polygon') {
        console.log('Polígono adicionado: ', layer);
    }
});
// Captura o evento de edição de objetos
map.on('draw:edited', function (e) {
    var layers = e.layers;
    layers.eachLayer(function (layer) {
        console.log('Objeto editado:', layer);
    });
});
// Captura o evento de exclusão de objetos
map.on('draw:deleted', function (e) {
    var layers = e.layers;
    layers.eachLayer(function (layer) {
        console.log('Objeto deletado:', layer);
    });
});

// ===== PrintMap =====
var printerControl = L.easyPrint({
    tileLayer: wmsJequieLayer,
    sizeModes: ['Current', 'A4Landscape', 'A4Portrait'],
    filename: 'mapa_impresso',
    exportOnly: false,
    hideControlContainer: true
}).addTo(map);

function manualPrint() {
    printer.printMap('CurrentSize', 'MyManualPrint')
}

// ===== imagens 360° =====
// Lista de imagens 360°
var fotos360 = [
  { lat: -13.837505, lng: -40.073685, imagem: 'voo360/DJI_0604.jpg', descricao: '360°...'},
  { lat: -13.838240, lng: -40.073859, imagem: 'voo360/DJI_0605.jpg', descricao: '360°...'},
  { lat: -13.838786, lng: -40.074009, imagem: 'voo360/DJI_0606.jpg', descricao: '360°...'},
  { lat: -13.839273, lng: -40.074159, imagem: 'voo360/DJI_0607.jpg', descricao: '360°...'},
  { lat: -13.839824, lng: -40.074302, imagem: 'voo360/DJI_0608.jpg', descricao: '360°...'},
  { lat: -13.840317, lng: -40.074449, imagem: 'voo360/DJI_0609.jpg', descricao: '360°...'},
  { lat: -13.840880, lng: -40.074627, imagem: 'voo360/DJI_0610.jpg', descricao: '360°...'},
  { lat: -13.841671, lng: -40.075071, imagem: 'voo360/DJI_0611.jpg', descricao: '360°...'},
  { lat: -13.841763, lng: -40.074604, imagem: 'voo360/DJI_0612.jpg', descricao: '360°...'},
  { lat: -13.840070, lng: -40.075544, imagem: 'voo360/DJI_0613.jpg', descricao: '360°...'},
  { lat: -13.839637, lng: -40.075401, imagem: 'voo360/DJI_0614.jpg', descricao: '360°...'},
  { lat: -13.839111, lng: -40.075256, imagem: 'voo360/DJI_0615.jpg', descricao: '360°...'},
  { lat: -13.838587, lng: -40.075108, imagem: 'voo360/DJI_0616.jpg', descricao: '360°...'},
  { lat: -13.838043, lng: -40.074950, imagem: 'voo360/DJI_0617.jpg', descricao: '360°...'},
  { lat: -13.837050, lng: -40.074658, imagem: 'voo360/DJI_0618.jpg', descricao: '360°...'},
  { lat: -13.836833, lng: -40.075176, imagem: 'voo360/DJI_0619.jpg', descricao: '360°...'},
  { lat: -13.836621, lng: -40.075670, imagem: 'voo360/DJI_0620.jpg', descricao: '360°...'},
  { lat: -13.837949, lng: -40.075516, imagem: 'voo360/DJI_0621.jpg', descricao: '360°...'},
  { lat: -13.839018, lng: -40.075796, imagem: 'voo360/DJI_0622.jpg', descricao: '360°...'},
  { lat: -13.839965, lng: -40.076059, imagem: 'voo360/DJI_0623.jpg', descricao: '360°...'},
  { lat: -13.840848, lng: -40.075654, imagem: 'voo360/DJI_0624.jpg', descricao: '360°...'},
  { lat: -13.840878, lng: -40.073405, imagem: 'voo360/DJI_0625.jpg', descricao: '360°...'},
  { lat: -13.841502, lng: -40.073466, imagem: 'voo360/DJI_0626.jpg', descricao: '360°...'},
  { lat: -13.840541, lng: -40.073329, imagem: 'voo360/DJI_0627.jpg', descricao: '360°...'},
  { lat: -13.840043, lng: -40.073208, imagem: 'voo360/DJI_0628.jpg', descricao: '360°...'},
  { lat: -13.839483, lng: -40.073033, imagem: 'voo360/DJI_0629.jpg', descricao: '360°...'},
  { lat: -13.838970, lng: -40.072892, imagem: 'voo360/DJI_0630.jpg', descricao: '360°...'},
  { lat: -13.838451, lng: -40.072742, imagem: 'voo360/DJI_0631.jpg', descricao: '360°...'},
  { lat: -13.837926, lng: -40.072590, imagem: 'voo360/DJI_0632.jpg', descricao: '360°...'},
  { lat: -13.838324, lng: -40.073302, imagem: 'voo360/DJI_0633.jpg', descricao: '360°...'},
  { lat: -13.837547, lng: -40.072427, imagem: 'voo360/Golden_06_25/DJI_0301.jpg', descricao: '360°...'},
  { lat: -13.836138, lng: -40.071772, imagem: 'voo360/Golden_06_25/DJI_0302.jpg', descricao: '360°...'},
  { lat: -13.835502, lng: -40.070525, imagem: 'voo360/Golden_06_25/DJI_0303.jpg', descricao: '360°...'},
  { lat: -13.835572, lng: -40.071616, imagem: 'voo360/Golden_06_25/DJI_0304.jpg', descricao: '360°...'},
  { lat: -13.834347, lng: -40.071286, imagem: 'voo360/Golden_06_25/DJI_0305.jpg', descricao: '360°...'},
  { lat: -13.833578, lng: -40.071125, imagem: 'voo360/Golden_06_25/DJI_0306.jpg', descricao: '360°...'},
  { lat: -13.832072, lng: -40.070722, imagem: 'voo360/Golden_06_25/DJI_0307.jpg', descricao: '360°...'},
  { lat: -13.831044, lng: -40.071267, imagem: 'voo360/Golden_06_25/DJI_0308.jpg', descricao: '360°...'},
  { lat: -13.830831, lng: -40.072133, imagem: 'voo360/Golden_06_25/DJI_0309.jpg', descricao: '360°...'},
  { lat: -13.830458, lng: -40.073606, imagem: 'voo360/Golden_06_25/DJI_0310.jpg', descricao: '360°...'},
  { lat: -13.829864, lng: -40.076189, imagem: 'voo360/Golden_06_25/DJI_0311.jpg', descricao: '360°...'},
  { lat: -13.835483, lng: -40.073442, imagem: 'voo360/Golden_06_25/DJI_0312.jpg', descricao: '360°...'},
  { lat: -13.834703, lng: -40.073217, imagem: 'voo360/Golden_06_25/DJI_0313.jpg', descricao: '360°...'},
  { lat: -13.835214, lng: -40.072269, imagem: 'voo360/Golden_06_25/DJI_0314.jpg', descricao: '360°...'},
  { lat: -13.834086, lng: -40.072156, imagem: 'voo360/Golden_06_25/DJI_0315.jpg', descricao: '360°...'},
  { lat: -13.833683, lng: -40.072608, imagem: 'voo360/Golden_06_25/DJI_0316.jpg', descricao: '360°...'},
  { lat: -13.833603, lng: -40.073750, imagem: 'voo360/Golden_06_25/DJI_0317.jpg', descricao: '360°...'},
  { lat: -13.833008, lng: -40.072894, imagem: 'voo360/Golden_06_25/DJI_0318.jpg', descricao: '360°...'},
  { lat: -13.832814, lng: -40.071519, imagem: 'voo360/Golden_06_25/DJI_0319.jpg', descricao: '360°...'},
  { lat: -13.832350, lng: -40.073472, imagem: 'voo360/Golden_06_25/DJI_0320.jpg', descricao: '360°...'},
  { lat: -13.832111, lng: -40.074200, imagem: 'voo360/Golden_06_25/DJI_0321.jpg', descricao: '360°...'},
  { lat: -13.832117, lng: -40.071389, imagem: 'voo360/Golden_06_25/DJI_0322.jpg', descricao: '360°...'},
  { lat: -13.831847, lng: -40.072844, imagem: 'voo360/Golden_06_25/DJI_0323.jpg', descricao: '360°...'},
  { lat: -13.831042, lng: -40.073736, imagem: 'voo360/Golden_06_25/DJI_0324.jpg', descricao: '360°...'},
  { lat: -13.830703, lng: -40.075106, imagem: 'voo360/Golden_06_25/DJI_0325.jpg', descricao: '360°...'},
  { lat: -13.831325, lng: -40.075258, imagem: 'voo360/Golden_06_25/DJI_0326.jpg', descricao: '360°...'},
  { lat: -13.833947, lng: -40.074439, imagem: 'voo360/Golden_06_25/DJI_0327.jpg', descricao: '360°...'},
];

// Definir ícone de drone
var droneIcon = L.icon({
  iconUrl: 'voo360/logo/camera-3605.png',
  iconSize: [32, 32],
  iconAnchor: [16, 32],
  popupAnchor: [0, -32],
  shadowUrl: null
});

// Criar LayerGroup (grupo de camadas) para os marcadores
var fotos360Layer = L.layerGroup();
fotos360.forEach(foto => {
  var marker = L.marker([foto.lat, foto.lng], { icon: droneIcon });
  marker.bindTooltip(foto.descricao);
  marker.on('click', () => abrirViewer(foto.imagem));
  fotos360Layer.addLayer(marker);
});

// Abrir o visualizador
function abrirViewer(imagemUrl) {
  document.getElementById("map").style.display = "none";
  document.getElementById("viewer").style.display = "block";
  document.getElementById("back-button").style.display = "block";
  document.getElementById("viewer").innerHTML = "";

  var viewer = new PhotoSphereViewer({
    panorama: imagemUrl,
    container: document.getElementById('viewer'),
    navbar: true,
    loadingImg: 'geojequie/css/images/GPI-LOGO_2s.gif',
  });
}

// Função global para voltar ao mapa
function backToMap(event) {
  if (event) event.preventDefault();

  document.getElementById("viewer").style.display = "none";
  document.getElementById("map").style.display = "block";
  document.getElementById("back-button").style.display = "none";
  document.getElementById("viewer").innerHTML = "";
}

// Alternar marcadores 360° ao clicar no botão "geo360"
var fotos360Ativado = false;
document.getElementById('geo360').addEventListener('click', () => {
  var botao = document.getElementById('geo360');

  if (!fotos360Ativado) {
    map.addLayer(fotos360Layer);
    botao.classList.add('ativo'); // ativa visual
    fotos360Ativado = true;
  } else {
    map.removeLayer(fotos360Layer);
    botao.classList.remove('ativo'); // desativa visual
    fotos360Ativado = false;
  }
});







