<?php
header('Content-Type: application/json');

try {
    // Etapa 1: Captura e validação
    $data = json_decode(file_get_contents('php://input'), true);

    if (!$data || empty($data['inscricao'])) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Dados obrigatórios não enviados']);
        exit;
    }

    // Etapa 2: Conexão com o banco
    $pdo = new PDO('pgsql:host=162.240.148.136;port=5432;dbname=wwsisp_postgres', 'postgres', 'R312@dm1nj3q');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Etapa 3: Determinar se é INSERT ou UPDATE
    $isUpdate = !empty($data['id']);

    if ($isUpdate) {
        // UPDATE
        $sql = "UPDATE avaliacoes_imobiliarias SET
            inscricao = :inscricao,
            zoneamento = :zoneamento,
            area_unida = :area_unida,
            tipo = :tipo,
            padrao = :padrao,
            valor_estimado = :valor_estimado,
            lote = :lote,
            quadra = :quadra,
            setor = :setor,
            numero_lot = :numero_lot,
            logradouro = :logradouro,
            bairro = :bairro,
            name = :name,
            latitude = :latitude,
            longitude = :longitude,
            usuario_id = :usuario_id
            WHERE id = :id";
    } else {
        // INSERT
        $sql = "INSERT INTO avaliacoes_imobiliarias (
            inscricao, zoneamento, area_unida, tipo, padrao,
            valor_estimado, lote, quadra, setor, numero_lot,
            logradouro, bairro, name, latitude, longitude, usuario_id
        ) VALUES (
            :inscricao, :zoneamento, :area_unida, :tipo, :padrao,
            :valor_estimado, :lote, :quadra, :setor, :numero_lot,
            :logradouro, :bairro, :name, :latitude, :longitude, :usuario_id
        )";
    }

    // Etapa 4: Preparar e executar a query
    $stmt = $pdo->prepare($sql);

    // Parâmetros comuns para INSERT e UPDATE
    $params = [
        ':inscricao'      => $data['inscricao'],
        ':zoneamento'     => $data['zoneamento'] ?? '',
        ':area_unida'     => $data['area_unida'] ?? 0,
        ':tipo'           => $data['tipo'] ?? '',
        ':padrao'         => $data['padrao'] ?? '',
        ':valor_estimado' => $data['valor_estimado'] ?? 0,
        ':lote'           => $data['lote'] ?? '',
        ':quadra'         => $data['quadra'] ?? '',
        ':setor'          => $data['setor'] ?? '',
        ':numero_lot'     => $data['numero_lot'] ?? '',
        ':logradouro'     => $data['logradouro'] ?? '',
        ':bairro'         => $data['bairro'] ?? '',
        ':name'           => $data['name'] ?? '',
        ':latitude'       => $data['latitude'] ?? '',
        ':longitude'      => $data['longitude'] ?? '',
        ':usuario_id'     => $data['usuario_id'] ?? null
    ];

    if ($isUpdate) {
        $params[':id'] = $data['id'];
    }

    $stmt->execute($params);

    echo json_encode(['status' => 'success', 'message' => 'Avaliação salva com sucesso']);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Erro no banco de dados: ' . $e->getMessage()]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Erro geral: ' . $e->getMessage()]);
}
