<?php
// Exibe erros diretamente na tela (importante para desenvolvimento)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Configuração do banco de dados
$host = "162.240.148.136";
$port = "5432";
$dbname = "wwsisp_postgres";
$user = "postgres";
$password = "R312@dm1nj3q";

// Lê os dados JSON enviados no body
$input = file_get_contents('php://input');

// Loga o texto cru para ver o que chega
error_log("INPUT CRU: " . $input);

$data = json_decode($input, true);

// Se houver erro na decodificação, retorna um erro
if ($data === null) {
    echo json_encode(["success" => false, "message" => "Erro ao decodificar JSON."]);
    exit;
}

// Extrai inscrição e nova situação dos dados
$inscricao = $data['inscricao'] ?? null;
$situacao = $data['situacao'] ?? null;

// Loga os dados decodificados para verificar se estão corretos
error_log("INSCRICAO: " . $inscricao);
error_log("SITUACAO: " . $situacao);

// Valida se os dados estão completos
if (empty($inscricao) || empty($situacao)) {
    echo json_encode(["status" => "error", "message" => "Dados incompletos."]);
    exit;
}

try {
    // Conectar ao banco de dados
    $dsn = "pgsql:host=$host;port=$port;dbname=$dbname;";
    $pdo = new PDO($dsn, $user, $password, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);

    // Atualizar a situação com base na inscrição
    $stmt = $pdo->prepare("UPDATE cadastrotributos SET situacao = :situacao WHERE inscricao = :inscricao");
    $stmt->bindParam(':situacao', $situacao);
    $stmt->bindParam(':inscricao', $inscricao);
    $stmt->execute();

    echo json_encode(['status' => 'ok']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>
