<?php
header('Content-Type: application/json; charset=utf-8');

// Caminho para o arquivo GeoJSON
$file = './geojson_edit/poligononuvem.geojson';

// Verifica se o diretório e o arquivo estão acessíveis
if (!is_writable('./geojson_edit/')) {
    echo json_encode(['success' => false, 'message' => 'Diretório não é gravável. Verifique as permissões.']);
    exit();
}

// Verifica se o arquivo GeoJSON existe
$geojson = [
    "type" => "FeatureCollection",
    "name" => "teste",
    "crs" => [
        "type" => "name",
        "properties" => [
            "name" => "urn:ogc:def:crs:EPSG::4674"
        ]
    ],
    "features" => []
];

if (file_exists($file)) {
    $json = file_get_contents($file);
    $geojson = json_decode($json, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['success' => false, 'message' => 'Erro ao ler o arquivo GeoJSON.']);
        exit();
    }
}

// Obtém os dados JSON do corpo da solicitação
$data = file_get_contents('php://input');
$newFeature = json_decode($data, true);

if (json_last_error() === JSON_ERROR_NONE && isset($newFeature['geometry'], $newFeature['properties'])) {
    $geojson['features'][] = [
        "type" => "Feature",
        "properties" => $newFeature['properties'],
        "geometry" => $newFeature['geometry']
    ];

    $updatedGeoJson = json_encode($geojson, JSON_PRETTY_PRINT);
    if (file_put_contents($file, $updatedGeoJson) === false) {
        echo json_encode(['success' => false, 'message' => 'Falha ao salvar o GeoJSON. Verifique as permissões do arquivo.']);
    } else {
        echo json_encode(['success' => true, 'message' => 'GeoJSON salvo com sucesso!']);
    }
    } else {
        echo json_encode(['success' => false, 'message' => 'Dados inválidos ou formato JSON incorreto.']);
    }

    $data = json_decode(file_get_contents('php://input'), true);
    $geometry = $data['geometry'];

    // Atualiza no banco (exemplo PostgreSQL com PostGIS)
    $query = "UPDATE polygons SET geometry = ST_GeomFromGeoJSON(:geometry) WHERE id = :id";
    $stmt = $pdo->prepare($query);
    $stmt->execute([
        ':geometry' => json_encode($geometry),
        ':id' => $data['id']
    ]);

    echo json_encode(['success' => true]);
?>
