<?php
// Verifica se os dados foram recebidos via POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Verifica se o ID foi recebido e é numérico
    if (isset($_POST['id']) && is_numeric($_POST['id'])) {
        $id = $_POST['id'];
    } else {
        // Se o ID não for válido, retorna uma mensagem de erro
        echo "ID inválido.";
        exit;
    }

    // Conecta-se ao banco de dados
    try {
        $db = new PDO('pgsql:host=162.240.148.136;port=5432;dbname=wwsisp_postgres;', 'postgres', 'R312@dm1nj3q');
        $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Prepara a consulta SQL para atualizar os atributos
        $sql = $db->prepare("UPDATE cadastrotributos SET name = :name, uti_atual = :uti_atual, numero_doc = :numero_doc, numero_lot = :numero_lot,
         area_terre = :area_terre, area_unida = :area_unida, lote = :lote  WHERE id = :id");

        // Define os parâmetros da consulta com base nos dados recebidos do formulário
        $sql->bindParam(':name', $_POST['name']);
        $sql->bindParam(':uti_atual', $_POST['uti_atual']);
        $sql->bindParam(':numero_doc', $_POST['numero_doc']);
        $sql->bindParam(':numero_lot', $_POST['numero_lot']);
        $sql->bindParam(':area_terre', $_POST['area_terre']);
        $sql->bindParam(':area_unida', $_POST['area_unida']);
        $sql->bindParam(':lote', $_POST['lote']);
        $sql->bindParam(':id', $id);

        // Executa a consulta SQL
        if ($sql->execute()) {
            echo "Atributos atualizados com sucesso.";
        } else {
            echo "Erro ao atualizar os atributos.";
        }
    } catch (PDOException $e) {
        // Em caso de erro na conexão com o banco de dados
        echo "Erro de banco de dados: " . $e->getMessage();
    }
} else {
    // Se os dados não foram recebidos via POST, retorna uma mensagem de erro
    echo "Requisição inválida.";
}
?>